<?php

function upload($files_type,$input_name,$upload_directory,$file_name)

{

	######## Check if the directory exist ########

	if(!file_exists($upload_directory))

	{

		$_SESSION['error'] = 'The directory '.$upload_directory.' is not writable. You must set permision 755 for directory'.$upload_directory.' !';

	}

	else

	{

		foreach($_FILES[$input_name]['name'] as $key => $null)

		{

			$file_ext = explode('.',$_FILES[$input_name]['name'][$key]);

			$file_ext = end($file_ext);

			if(empty($file_name))

			{

				$file_name = str_replace('.'.$file_ext,'','Image');

			}

			

			$file['error'] = $_FILES[$input_name]['error'][$key];

			$file['type'] = $_FILES[$input_name]['type'][$key];

			$file['name'] = $_FILES[$input_name]['name'][$key];

			$file['tmp_name'] = $_FILES[$input_name]['tmp_name'][$key];

			

			

			######## Check for errors #########

			if($file['error'] != 0)

			{

				$_SESSION['error'] = 'One or more files were not uploaded !';

			}

			

			######## Check if the file format is accepted ########

			elseif(!in_array($file['type'],$files_type))

			{

				$_SESSION['error'] = 'One or more files were not uploaded. Seems like the type of the file is not accepted !';

			}

			

			else

			{

				foreach(range(1,100) as $i)

				{

					if(substr($file['type'],0,5) == 'image')

					{

						$filename = $file_name.'_'.$i.'.png';

					}

					else

					{

						$filename = 'File_'.$i.'.'.$file_ext;

					}

					if(!file_exists($upload_directory.'/'.$filename))

					{

						break;

					}

				}

				if(isset($filename))

				{

					######## Convert image to PNG #######

					$img = @imagecreatefromstring(file_get_contents($file['tmp_name']));

					imagealphablending($img, false);

					imagesavealpha($img, true);

					imagepng($img, $file['tmp_name']);

					

					####### Check if image is uploaded ########

					if(!move_uploaded_file($file['tmp_name'], $upload_directory.'/'.$filename))

					{

						$_SESSION['error'] = 'One or more files were not uploaded. Error : move_uploaded_file failed ! '. $upload_directory.'/'.$filename;

					}

					unset($filename);

				}

			}

		}

	}

}

